CXX = icpc -i-static
CXXFLAGS = -O2 -mp -prec_div -long_double

DIFF = ./sdiff
PRE = ./
MAJOR = 101
MINOR = 0

%.o:           	%.cpp
		$(CXX) $(CXXFLAGS) -c $*.cpp

everything:    	plotdemo 

newmat_lobj = newmat1.o newmat2.o newmat3.o newmat4.o newmat5.o newmat6.o newmat7.o newmat8.o newmatex.o bandmat.o submat.o myexcept.o cholesky.o evalue.o fft.o hholder.o jacobi.o newfft.o sort.o svd.o nm_misc.o newmatrm.o newmat9.o

libnewmat.a:   	$(newmat_lobj)
		$(AR) -cr $@ $(newmat_lobj)
		ranlib $@

str_lobj = str.o myexcept.o format.o liststr.o gstring.o str_fns.o commline.o

libstr.a:      	$(str_lobj)
		$(AR) -cr $@ $(str_lobj)
		ranlib $@

plotdemo_obj = plotdemo.o gnuplot.o callplot.o

plotdemo:      	$(plotdemo_obj) libstr.a libnewmat.a
		$(CXX) -o $@ $(plotdemo_obj) -L. -lstr -lnewmat -lm

newmat1.o:     	newmat1.cpp newmat.h include.h myexcept.h

newmat2.o:     	newmat2.cpp include.h newmat.h newmatrc.h myexcept.h controlw.h

newmat3.o:     	newmat3.cpp include.h newmat.h newmatrc.h myexcept.h controlw.h

newmat4.o:     	newmat4.cpp include.h newmat.h newmatrc.h myexcept.h controlw.h

newmat5.o:     	newmat5.cpp include.h newmat.h newmatrc.h myexcept.h controlw.h

newmat6.o:     	newmat6.cpp include.h newmat.h newmatrc.h myexcept.h controlw.h

newmat7.o:     	newmat7.cpp include.h newmat.h newmatrc.h myexcept.h controlw.h

newmat8.o:     	newmat8.cpp include.h newmat.h newmatrc.h precisio.h myexcept.h controlw.h

newmatex.o:    	newmatex.cpp include.h newmat.h myexcept.h

bandmat.o:     	bandmat.cpp include.h newmat.h newmatrc.h myexcept.h controlw.h

submat.o:      	submat.cpp include.h newmat.h newmatrc.h myexcept.h controlw.h

myexcept.o:    	myexcept.cpp include.h myexcept.h

cholesky.o:    	cholesky.cpp include.h newmat.h newmatrm.h myexcept.h

evalue.o:      	evalue.cpp include.h newmatap.h newmatrm.h precisio.h newmat.h myexcept.h

fft.o:         	fft.cpp include.h newmatap.h newmat.h myexcept.h

hholder.o:     	hholder.cpp include.h newmatap.h newmat.h myexcept.h

jacobi.o:      	jacobi.cpp include.h newmatap.h precisio.h newmatrm.h newmat.h myexcept.h

newfft.o:      	newfft.cpp newmatap.h newmat.h include.h myexcept.h

sort.o:        	sort.cpp include.h newmatap.h newmat.h myexcept.h

svd.o:         	svd.cpp include.h newmatap.h newmatrm.h precisio.h newmat.h myexcept.h

nm_misc.o:     	nm_misc.cpp include.h newmatap.h newmat.h myexcept.h

newmatrm.o:    	newmatrm.cpp newmat.h newmatrm.h include.h myexcept.h

newmat9.o:     	newmat9.cpp include.h newmat.h newmatio.h newmatrc.h myexcept.h controlw.h

str.o:         	str.cpp include.h str.h myexcept.h

format.o:      	format.cpp include.h str.h format.h myexcept.h

liststr.o:     	liststr.cpp include.h str.h gstring.h str_fns.h myexcept.h

gstring.o:     	gstring.cpp include.h str.h gstring.h myexcept.h str_fns.h

str_fns.o:     	str_fns.cpp str.h str_fns.h include.h myexcept.h

commline.o:    	commline.cpp include.h myexcept.h str.h commline.h str_fns.h

plotdemo.o:    	plotdemo.cpp include.h str.h newmatio.h gnuplot.h myexcept.h newmat.h str_fns.h

gnuplot.o:     	gnuplot.cpp gnuplot.h newmatio.h callplot.h include.h newmat.h str.h str_fns.h myexcept.h

callplot.o:    	callplot.cpp include.h str.h callplot.h myexcept.h

plotdemo.txx:  	plotdemo
		$(PRE)plotdemo > plotdemo.txx
		$(DIFF) plotdemo.txt plotdemo.txx

