CXX = g++
CXXFLAGS = -O2 -Wall

DIFF = ./sdiff
PRE = ./
MAJOR = 1
MINOR = 0

%.o:           	%.cpp
		$(CXX) $(CXXFLAGS) -c $*.cpp

everything:    	genmake sdiff 

str_lobj = str.o myexcept.o format.o liststr.o gstring.o str_fns.o commline.o

libstr.a:      	$(str_lobj)
		$(AR) -cr $@ $(str_lobj)
		ranlib $@

genmake_obj = genmake.o

genmake:       	$(genmake_obj) libstr.a
		$(CXX) -o $@ $(genmake_obj) -L. -lstr -lm

sdiff_obj = sdiff.o

sdiff:         	$(sdiff_obj) libstr.a
		$(CXX) -o $@ $(sdiff_obj) -L. -lstr -lm

str.o:         	str.cpp include.h str.h myexcept.h

myexcept.o:    	myexcept.cpp include.h myexcept.h

format.o:      	format.cpp include.h str.h format.h myexcept.h

liststr.o:     	liststr.cpp include.h str.h gstring.h str_fns.h myexcept.h

gstring.o:     	gstring.cpp include.h str.h gstring.h myexcept.h str_fns.h

str_fns.o:     	str_fns.cpp str.h str_fns.h include.h myexcept.h

commline.o:    	commline.cpp include.h myexcept.h str.h commline.h str_fns.h

genmake.o:     	genmake.cpp include.h str.h gstring.h commline.h myexcept.h str_fns.h

sdiff.o:       	sdiff.cpp include.h str.h gstring.h commline.h myexcept.h str_fns.h

genmake.txx:   	genmake
		$(PRE)genmake > genmake.txx
		$(DIFF) genmake.txt genmake.txx

sdiff.txx:     	sdiff
		$(PRE)sdiff > sdiff.txx
		$(DIFF) sdiff.txt sdiff.txx

